<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<xsl:template match="/">

<html>
<body>

<xsl:variable name="Indusibauart" select="Fahrtenschreiber/kopf/Props/@IndusiBauart" />
<xsl:variable name="IndusiProgramm" select="Fahrtenschreiber/kopf/Props/@IndusiProgramm" />


<table width="1000">
<tr bgcolor="#EEEEEE"><td style="font-size:24pt; color:red" width="50"><b>LokSim</b></td><td style="font-size:24pt; color:red"  width="250">Fahrtenschreiber</td>
<td>Datum:</td>
<td><xsl:value-of select="Fahrtenschreiber/kopf/Props/@Datum" /></td>
</tr>





<tr bgcolor="#EEEEEE"><td  width="20%">Lok:</td>
<td align="left"  width="50%">
<b><xsl:value-of select="Fahrtenschreiber/kopf/Props/@Lokname" /></b>
</td>
<td  width="10%">Version:</td>
<td align="left"  width="20%"><xsl:value-of select="Fahrtenschreiber/kopf/Props/@LokVersion" /></td>
</tr>

<tr bgcolor="#EEEEEE"><td>Fahrplan:</td>
<td align="left">
<b><xsl:value-of select="Fahrtenschreiber/kopf/Props/@Zugname" /></b>
<td></td>
<td></td>
</td></tr>



<tr bgcolor="#EEEEEE"><td>Indusibauart:</td>

<xsl:choose>
	<xsl:when test="$Indusibauart = 1">
		<td  align="left" bgcolor="#EEEEEE"><b>I60R</b></td>
	</xsl:when>
	<xsl:when test="$Indusibauart = 2">
		<td  align="eft" bgcolor="#EEEEEE"><b>I60</b></td>
	</xsl:when>
	<xsl:when test="$Indusibauart = 3">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZB90 V1.5</b></td><!-- PZB90 V1.5 || PZB90 I60R -->
	</xsl:when>
	<xsl:when test="$Indusibauart = 4">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZB90 V1.6</b></td><!-- PZB90 V1.6 || PZB90 I60-->
	</xsl:when>
	<xsl:when test="$Indusibauart = 5">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZ80R</b></td>
	</xsl:when>
	<xsl:when test="$Indusibauart = 6">
		<td  align="eft" bgcolor="#EEEEEE"><b>LVZ</b></td>
	</xsl:when>
	<xsl:when test="$Indusibauart = 7">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZ80</b></td>
	</xsl:when>
	<xsl:when test="$Indusibauart = 8">
		<td  align="eft" bgcolor="#EEEEEE"><b>Fahrsperre</b></td>
	</xsl:when>
	<xsl:when test="$Indusibauart = 9">
		<td  align="eft" bgcolor="#EEEEEE"><b>SBB-Signum</b></td>
	</xsl:when>	
	<xsl:when test="$Indusibauart = 10">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZB90 V2.0</b></td>
	</xsl:when>		
	<xsl:when test="$Indusibauart = 11">
		<td  align="eft" bgcolor="#EEEEEE"><b>NL</b></td>
	</xsl:when>		
	<xsl:when test="$Indusibauart = 12">
		<td  align="eft" bgcolor="#EEEEEE"><b>SBB-Signum o. HS</b></td>
	</xsl:when>		
	
	<xsl:when test="$Indusibauart = 13">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZB90 I60R</b></td>
	</xsl:when>		
	<xsl:when test="$Indusibauart = 14">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZB90 I60/ER24</b></td>
	</xsl:when>		
	<xsl:when test="$Indusibauart = 15">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZB90 PZ80R</b></td>
	</xsl:when>			
	<xsl:when test="$Indusibauart = 16">
		<td  align="eft" bgcolor="#EEEEEE"><b>PZB90 I80</b></td>
	</xsl:when>			
	<xsl:otherwise>
		<td>keine vorhanden!</td>
	</xsl:otherwise>	
</xsl:choose>
<td></td>
<td></td>

</tr>











<tr bgcolor="#EEEEEE"><td>Indusiprogramm:</td>

<xsl:choose>
	<xsl:when test="$IndusiProgramm = 1">
		<td  align="left" bgcolor="#EEEEEE"><b>Zugart U (G)</b></td>
	</xsl:when>
	<xsl:when test="$IndusiProgramm = 2">
		<td  align="eft" bgcolor="#EEEEEE"><b>Zugart M (P)</b></td>
	</xsl:when>
	<xsl:when test="$IndusiProgramm = 3">
		<td  align="eft" bgcolor="#EEEEEE"><b>Zugart O (R)</b></td>
	</xsl:when>
	<xsl:otherwise>
		<td></td>
	</xsl:otherwise>

</xsl:choose>
<td></td>
<td></td>

</tr>







</table>

<xsl:call-template name="Messwerte">
<xsl:with-param name="Zaehler" select="Fahrtenschreiber/kopf/Props/@AnzEintraege" />
<xsl:with-param name="AZaehler" select="0" />
</xsl:call-template>


</body>
</html>
</xsl:template>





<xsl:template name="Messwerte">
<xsl:param name="Zaehler" />
<xsl:param name="AZaehler" />

<table width="1500">
<tr  align="center">
<td  bgcolor="#CCCCCC" width="7%">Nr.</td>
<td  bgcolor="#CCCCCC" width="7%">Position (Str.-km)</td>
<td  bgcolor="#CCCCCC" width="7%">Zeit</td>
<td  bgcolor="#CCCCCC" width="7%">Zwangs.-Bremse</td>
<td  bgcolor="#CCCCCC" width="7%">V-Ist (km/h)</td>
<td  bgcolor="#CCCCCC" width="7%">V-Soll (km/h)</td>
<td  bgcolor="#CCCCCC" width="7%">V-Soll PZB (km/h)</td>
<td  bgcolor="#CCCCCC" width="7%">Dyn.-Stufe</td>
<td  bgcolor="#CCCCCC" width="7%">Pneu.-BDruck (HLL)</td>
<td  bgcolor="#CCCCCC" width="7%">BDruck (BLL)</td>
<td  bgcolor="#CCCCCC" width="7%">Mg.-Bremse</td>
<td  bgcolor="#CCCCCC" width="7%">Sp.-Bremse</td>
<td  bgcolor="#CCCCCC" width="7%">Lok-Bremse</td>
<td  bgcolor="#CCCCCC" width="7%">Wagen-Bremse</td>
<td  bgcolor="#CCCCCC" width="7%">H-Bremse</td>
<td  bgcolor="#CCCCCC" width="7%">Stufe</td>
<td  bgcolor="#CCCCCC" width="7%">Tr</td>
<td  bgcolor="#CCCCCC" width="7%">I95</td>
<td  bgcolor="#CCCCCC" width="7%">I75</td>
<td  bgcolor="#CCCCCC" width="7%">I55</td>
<td  bgcolor="#CCCCCC" width="7%">1000er</td>
<td  bgcolor="#CCCCCC" width="7%">500er</td>
<td  bgcolor="#CCCCCC" width="7%">E40</td>
<td  bgcolor="#CCCCCC" width="7%">V40</td>
<td  bgcolor="#CCCCCC" width="7%">WBL</td>
<td  bgcolor="#CCCCCC" width="7%">SBL</td>
<td  bgcolor="#CCCCCC" width="7%">1000</td>
<td  bgcolor="#CCCCCC" width="7%">500</td>
<td  bgcolor="#CCCCCC" width="7%">Quit</td>
<td  bgcolor="#CCCCCC" width="7%">ZsQuit</td>
<td  bgcolor="#CCCCCC" width="7%">Zs1</td>
<td  bgcolor="#CCCCCC" width="7%">Zs7</td>
<td  bgcolor="#CCCCCC" width="7%">Zs8</td>
<td  bgcolor="#CCCCCC" width="7%">ZBS</td>
<td  bgcolor="#CCCCCC" width="7%">Rest</td>
<td  bgcolor="#CCCCCC" width="7%">Umsch</td>


</tr>



<xsl:for-each select="Fahrtenschreiber/Messung">
<tr>
<xsl:variable name="dybrstufe" select="Props/@DynBremsstufe" />
<xsl:variable name="pneubdruck" select="Props/@PneuBremsdruck" />
<xsl:variable name="Bremszylinder" select="Props/@Bremszylinder" />
<xsl:variable name="MagnetBremskraft" select="Props/@MagnetBremskraft" />
<xsl:variable name="SpeicherBremskraft" select="Props/@SpeicherBremskraft" />
<xsl:variable name="HBremsung" select="Props/@Anz-HBremsung" />
<xsl:variable name="VIst" select="Props/@VIst" />
<xsl:variable name="VSoll" select="Props/@VSoll" />
<xsl:variable name="VSollPZB" select="Props/@VSollPZB" />
<xsl:variable name="ZBRSIFA" select="Props/@ZbsSifa" />
<xsl:variable name="ZBRINDUSI" select="Props/@ZbsIndusi" />
<xsl:variable name="ZBRLZB" select="Props/@ZbsLZB" />
<xsl:variable name="Tuerverriegelung" select="Props/@Tuerverriegelung" />
<xsl:variable name="Tuerstatus" select="Props/@Tuerstatus" />
<xsl:variable name="PZBProt" select="Props/@PZBProt" />
<xsl:variable name="PZBProt_I95" select="Props/@PZBProt_I95" />
<xsl:variable name="PZBProt_I75" select="Props/@PZBProt_I75" />
<xsl:variable name="PZBProt_I55" select="Props/@PZBProt_I55" />
<xsl:variable name="PZBProt_Anz1000" select="Props/@PZBProt_Anz1000" />
<xsl:variable name="PZBProt_Anz500" select="Props/@PZBProt_Anz500" />
<xsl:variable name="PZBProt_E40" select="Props/@PZBProt_E40" />
<xsl:variable name="PZBProt_V40" select="Props/@PZBProt_V40" />
<xsl:variable name="PZBProt_WBlinken" select="Props/@PZBProt_WBlinken" />
<xsl:variable name="PZBProt_WStartblinken" select="Props/@PZBProt_WStartblinken" />
<xsl:variable name="PZBProt_Ue1000" select="Props/@PZBProt_Ue1000" />
<xsl:variable name="PZBProt_Ue500" select="Props/@PZBProt_Ue500" />
<xsl:variable name="PZBProt_Quit" select="Props/@PZBProt_Quit" />
<xsl:variable name="PZBProt_ZsQuit" select="Props/@PZBProt_ZsQuit" />
<xsl:variable name="PZBProt_Zs1" select="Props/@PZBProt_Zs1" />
<xsl:variable name="PZBProt_Zs7" select="Props/@PZBProt_Zs7" />
<xsl:variable name="PZBProt_Zs8" select="Props/@PZBProt_Zs8" />
<xsl:variable name="PZBProt_Zbs" select="Props/@PZBProt_Zbs" />
<xsl:variable name="RestriktivAktiv" select="Props/@RestriktivAktiv" />
<xsl:variable name="UmschaltAktiv" select="Props/@UmschaltAktiv" />

<td align="right" ><xsl:value-of select="Props/@Number" /></td>
<td align="right" ><xsl:value-of select="Props/@SimPos" /></td>
<td align="right" ><xsl:value-of select="Props/@CTime" /></td>





<xsl:choose>
	<xsl:when test="$ZBRSIFA = 1">
		<td  align="center" bgcolor="#FFFF99">Sifa</td>
	</xsl:when>
	<xsl:when test="$ZBRINDUSI = 1">
		<td  align="center" bgcolor="#FFFF99">Indusi</td>
	</xsl:when>
	<xsl:when test="$ZBRLZB = 1">
		<td  align="center" bgcolor="#FFFF99">LZB</td>
	</xsl:when>
	<xsl:otherwise>
		<td></td>
	</xsl:otherwise>

</xsl:choose>




<xsl:choose>
<xsl:when test="$VIst &lt;= $VSoll*1.05">
	<td  align="right"><xsl:value-of select="Props/@VIst" /></td>
</xsl:when>
<xsl:otherwise>
	<td  align="right" bgcolor="#FF6666" ><xsl:value-of select="Props/@VIst" /></td>
</xsl:otherwise>
</xsl:choose>

<td  align="right"><xsl:value-of select="Props/@VSoll" /></td>



<xsl:choose>
<xsl:when test="$VSollPZB &gt; 0">
	<td  align="right" bgcolor="#FFFF99"><xsl:value-of select="Props/@VSollPZB" /></td>
</xsl:when>
<xsl:otherwise>
	<td></td>
</xsl:otherwise>
</xsl:choose>




<xsl:choose>
<xsl:when test="$dybrstufe &lt; 1">
	<td  align="right"><xsl:value-of select="Props/@DynBremsstufe" /></td>
</xsl:when>
<xsl:otherwise>
	<td  align="right" bgcolor="#FFFF99"><xsl:value-of select="Props/@DynBremsstufe" /></td>
</xsl:otherwise>
</xsl:choose>




<xsl:choose>
<xsl:when test="$pneubdruck &gt; 4.9">
	<td  align="right"><xsl:value-of select="Props/@PneuBremsdruck" /></td>
</xsl:when>
<xsl:otherwise>
	<td  align="right" bgcolor="#FFFF99"><xsl:value-of select="Props/@PneuBremsdruck" /></td>
</xsl:otherwise>
</xsl:choose>


<xsl:choose>
<xsl:when test="$Bremszylinder = 0">
	<td  align="right"><xsl:value-of select="Props/@Bremszylinder" /></td>
</xsl:when>
<xsl:otherwise>
	<td  align="right" bgcolor="#FFFF99"><xsl:value-of select="Props/@Bremszylinder" /></td>
</xsl:otherwise>
</xsl:choose>


<xsl:choose>
<xsl:when test="$MagnetBremskraft = 0">
	<td></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FFFF99">aktiv</td>
</xsl:otherwise>
</xsl:choose>




<xsl:choose>
<xsl:when test="$SpeicherBremskraft = 0">
	<td></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FFFF99">aktiv</td>
</xsl:otherwise>
</xsl:choose>


<td align="right"><xsl:value-of select="Props/@PneuBremskraft" /></td>
<td align="right"><xsl:value-of select="Props/@PneuWagenBremskraft" /></td>

<xsl:choose>
	<xsl:when test="$HBremsung = 1">
		<td  align="center" bgcolor="#00C000">ein</td>
	</xsl:when>
	<xsl:when test="$HBremsung = 0">
		<td></td>
	</xsl:when>
</xsl:choose>




<td align="right"><xsl:value-of select="Props/@Fahrstufe" /></td>


<xsl:choose>
	<xsl:when test="$Tuerstatus = 1">
		<xsl:choose>
		<xsl:when test="$Tuerverriegelung = 1">
			<td  align="center" bgcolor="#00C000">offen</td>
		</xsl:when>
		<xsl:when test="$Tuerverriegelung = 0">
			<td  align="center" bgcolor="#FF6666">offen</td>
		</xsl:when>
		</xsl:choose>
	</xsl:when>
	<xsl:when test="$Tuerstatus = 2">
		<xsl:choose>
		<xsl:when test="$Tuerverriegelung = 1">
			<td  align="center" bgcolor="#00C000">schl.</td>
		</xsl:when>
		<xsl:when test="$Tuerverriegelung = 0">
			<td  align="center" bgcolor="#FF6666">schl.</td>
		</xsl:when>
		</xsl:choose>
	</xsl:when>
	<xsl:when test="$Tuerstatus = 3">
		<xsl:choose>
		<xsl:when test="$Tuerverriegelung = 1">
			<td  align="center" bgcolor="#00C000">oeff.</td>
		</xsl:when>
		<xsl:when test="$Tuerverriegelung = 0">
			<td  align="center" bgcolor="#FF6666">oeff.</td>
		</xsl:when>
		</xsl:choose>
	</xsl:when>
	<xsl:when test="$Tuerstatus = 0">
		<xsl:choose>
		<xsl:when test="$Tuerverriegelung = 1">
			<td  align="center" bgcolor="#00C000">zu</td>
		</xsl:when>
		<xsl:when test="$Tuerverriegelung = 0">
			<td  align="center" bgcolor="#FF6666">zu</td>
		</xsl:when>
		</xsl:choose>
	</xsl:when>
	<xsl:otherwise></xsl:otherwise>

</xsl:choose>



<xsl:choose>
<xsl:when test="$PZBProt_I95 = 0">
	<td  align="center" bgcolor="#FFFF99"></td>
</xsl:when>
<xsl:when test="$PZBProt_I95 = 1">
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:when>
<xsl:when test="$PZBProt_I95 = 2">
	<td  align="center" bgcolor="#FF6666">b</td>
</xsl:when>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_I75 = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:when test="$PZBProt_I75 = 1">
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:when>
<xsl:when test="$PZBProt_I75 = 2">
	<td  align="center" bgcolor="#FF6666">b</td>
</xsl:when>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_I55 = 0">
	<td  align="center" bgcolor="#FFFFF9"></td>
</xsl:when>
<xsl:when test="$PZBProt_I55 = 1">
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:when>
<xsl:when test="$PZBProt_I55 = 2">
	<td  align="center" bgcolor="#FF6666">b</td>
</xsl:when>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Anz1000 = 0">
	<td  align="center" bgcolor="#FFFF99"></td>
</xsl:when>
<xsl:when test="$PZBProt_Anz1000 = 1">
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:when>
<xsl:when test="$PZBProt_Anz1000 = 2">
	<td  align="center" bgcolor="#FF6666">b</td>
</xsl:when>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Anz500 = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_E40 = 0">
	<td  align="center" bgcolor="#FFFFF9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_V40 = 0">
	<td  align="center" bgcolor="#FFFF99"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_WBlinken = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_WStartblinken = 0">
	<td  align="center" bgcolor="#FFFFF9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Ue1000 = 0">
	<td  align="center" bgcolor="#FFFF99"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Ue500 = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Quit = 0">
	<td  align="center" bgcolor="#FFFFF9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_ZsQuit = 0">
	<td  align="center" bgcolor="#FFFF99"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Zs1 = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Zs7 = 0">
	<td  align="center" bgcolor="#FFFFF9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Zs8 = 0">
	<td  align="center" bgcolor="#FFFF99"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$PZBProt_Zbs = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

<xsl:choose>
<xsl:when test="$RestriktivAktiv = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>
<xsl:choose>
<xsl:when test="$UmschaltAktiv = 0">
	<td  align="center" bgcolor="#FFFFC9"></td>
</xsl:when>
<xsl:otherwise>
	<td  align="center" bgcolor="#FF6666">*</td>
</xsl:otherwise>
</xsl:choose>

</tr>
</xsl:for-each>
<tr><td> </td></tr>
<tr>
<td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td align="right">Status:</td>
<td  bgcolor="#FF6666" align="center">entriegelt</td>
</tr>
<tr>
<td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
<td  bgcolor="#00C000" align="center">verriegelt</td>
</tr>





























</table>
<table width="1000">
<tr></tr>
<tr>
<td  bgcolor="#FFFF99" width="20%"   align="center">Aktiv</td>
<td  width="60%"   align="left">Die entsprechende Einrichtung wurde aktiviert.</td>
</tr>
<tr>
<td  bgcolor="#FF6666" width="20%"   align="center">berschreitung / offen</td>
<td  width="60%"   align="left">Es wurde ein Wert berschritten.</td>
</tr>
<tr>
<td  bgcolor="#00C000" width="20%"   align="center">geschlossen / I.O.</td>
<td  width="60%"   align="left">Der Zustand einer Einrichtung ist in Ordnung.</td>
</tr>
<tr></tr>

<tr>
<td  width="10%"   align="center"></td>
<td  width="90%" style="font-size:9pt"  align="left">Dieses Tabellenlayout ist Inhalt des Projektes LokSim3D.</td>
</tr>
</table>









<table width="1000">
<tr bgcolor="#EEEEEE"><td style="font-size:24pt; color:red" width="50"><b>Fahrplan</b></td>
</tr>
</table>



<table width="1000">
<tr  align="center">
<td  align="left" width="7%"><b>Ankunft</b></td>
<td  align="left" width="7%"><b>Abfahrt</b></td>
<td  align="left" width="13%"><b>Versptungsminuten</b></td>
<td  align="left" width="80%"><b>Haltpunkt</b></td>
</tr>




<xsl:for-each select="Fahrtenschreiber/Halt">

<xsl:variable name="AnkunftVersp" select="Props/@AnkunftVersp" />
<tr>

<td align="left" ><xsl:value-of select="Props/@Ankunft" /></td>
<td align="left" ><xsl:value-of select="Props/@Abfahrt" /></td>


<xsl:choose>
<xsl:when test="$AnkunftVersp &gt; 0">
	<td align="left" bgcolor="#FFFF99"><xsl:value-of select="Props/@AnkunftVersp" /></td>
</xsl:when>
<xsl:otherwise>
	<td></td>
</xsl:otherwise>
</xsl:choose>



<td align="left" ><xsl:value-of select="Props/@Name" /></td>

</tr>
</xsl:for-each>
</table>






<table width="1000">
<tr bgcolor="#EEEEEE"><td style="font-size:24pt; color:red" width="50"><b> </b></td></tr>
<tr bgcolor="#EEEEEE"><td style="font-size:24pt; color:red" width="50"><b>Wertung</b></td></tr>
</table>


<table width="1000">
<tr  align="center">
<td  align="left" width="30%"><b>Ereignis</b></td>
<td  align="left" width="70%"><b>Anzahl / Punkte</b></td>
</tr>
<tr>
<td  align="left" >Anzahl LZB-Zwangsbremsungen</td>
<td align="left"  ><xsl:value-of select="Fahrtenschreiber/Wertung/Props/@Anz_IndusiLZB" /></td>
</tr>
<tr>
<td  align="left" >Anzahl Sifa-Zwangsbremsungen</td>
<td align="left"  ><xsl:value-of select="Fahrtenschreiber/Wertung/Props/@Anz_SifaZBS" /></td>
</tr>
<tr>
<td  align="left" >Anzahl Indusi-Zwangsbremsungen</td>
<td align="left"  ><xsl:value-of select="Fahrtenschreiber/Wertung/Props/@Anz_IndusiZBS" /></td>
</tr>
<tr>
<td  align="left" >Anzahl Versptungsminuten</td>
<td align="left"  ><xsl:value-of select="Fahrtenschreiber/Wertung/Props/@Verspaetungsminuten" /></td>
</tr>
<tr>
<td  align="left" >Anzahl ausgelassene Planhalte</td>
<td align="left"  ><xsl:value-of select="Fahrtenschreiber/Wertung/Props/@Anz_ErrorHalt" /></td>
</tr>
<tr>
<td></td><td></td>
</tr>
<tr>
<td  align="left" bgcolor="#EEEEEE" ><b>Gesamtwertung (%)</b></td>
<td align="left"  bgcolor="#EEEEEE" ><b><xsl:value-of select="Fahrtenschreiber/Wertung/Props/@Punkte" /></b></td>

</tr>
</table>






</xsl:template>

</xsl:stylesheet>

